/*
 * $Id: r128fb_accel.h,v 1.6 2003/08/19 07:11:05 obi Exp $
 *
 * ATI Rage 128 Framebuffer Driver
 *
 * Copyright (C) 2003 Andreas Oberritter <obi@saftware.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 *
 * This driver has been widely inspired by the Rage 128 drivers of
 * XFree86 4.x, Linux 2.4.x and svgalib 1.9.x. Thanks to everybody
 * who contributed to them.
 *
 */

#ifndef _R128FB_ACCEL_H
#define _R128FB_ACCEL_H

#include "r128fb_base.h"

#if !defined(R128FB_ACCEL_MODULE)
int r128fb_accel_init_single(int index);
void r128fb_accel_exit_single(int index);
#endif /* R128FB_ACCEL_MODULE */

void r128fb_wait_for_fifo(struct r128_info_rec *info, u16 entries);

#endif /* _R128FB_ACCEL_H */
